﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Snake__Teil_1_
{
    class Program
    {
        // Voreinstellungen (Konstanten)
        // =============================
        // Fenstergröße festlegen
        const int windowWidth = 80;
        const int windowHeight = 40;

        // Unterer Rand für Spielinfos
        const int bottomBorder = 10;

        // Hintergrundfarbe Spielfeld
        const ConsoleColor gameBackgroundColor = ConsoleColor.White;

        // Vordergrundfarbe Spielfeldrand
        const ConsoleColor gameBorderColor = ConsoleColor.Black;

        // Zeichen für Spielfeldrand
        const char gameBorderCharacter = '#';

        static void Main(string[] args)
        {
            // =============================================
            // Variablen
            // =============================================
            // =============================================
            // Informationen zur Anzeige
            // =============================================
            // Der Inhalt dieses Arrays wird zur Darstellung
            // der aktuellen Spielsituation ausgegeben
            // gameArea[rows, columns]
            char[,] gameArea = new char[windowHeight - bottomBorder, windowWidth];
            // =============================================

            // =============================================
            // Initialisierung des Spiels
            // Fenster initialisieren
            initializeWindow();

            // Spielfeld initialisiere
            initializeGameArea(gameArea);

            // Inhalt des Spielfeldes und Statusinformationen
            // auf Bildschirm ausgeben
            drawScreen(gameArea);
        }

        // Methoden zu Initialisierung
        // =======================================================
        // Konsolenfenster initialisieren
        static void initializeWindow()
        {
            // Fenster einstellen
            Console.SetWindowSize(1, 1);
            Console.SetBufferSize(windowWidth, windowHeight);
            Console.SetWindowSize(windowWidth, windowHeight);
            Console.Title = "Snake (by Uwe Homm)";

            Console.BackgroundColor = gameBackgroundColor;
            Console.CursorVisible = false;
            Console.Clear();
        }

        // Spielfeld initialisieren
        static void initializeGameArea(char[,] gameArea)
        {
            // Array mit Leerzeichen vorbelegen
            for (int row = 0; row < windowHeight - bottomBorder; row++)
            {
                for (int column = 0; column < windowWidth; column++)
                {
                    gameArea[row, column] = ' ';
                }
            }
            // Zeichnen der Spielfeldumrandung
            // Oberen und unteren Rand zeichnen
            for (int xPos = 0; xPos < windowWidth; xPos++)
            {
                gameArea[0, xPos] = gameBorderCharacter;
                gameArea[windowHeight - bottomBorder - 1, xPos] = gameBorderCharacter;
            }

            // Linken und rechten Rand zeichnen
            for (int yPos = 1; yPos < windowHeight - bottomBorder - 1; yPos++)
            {
                Console.SetCursorPosition(0, yPos);
                gameArea[yPos, 0] = gameBorderCharacter;
                gameArea[yPos, windowWidth - 1] = gameBorderCharacter;
            }
        }

        // Methoden zur Spiellogik
        // =======================================================
        // Gibt den Inhalt des Spielfeldes im Fenster aus
        static void drawScreen(char[,] gameArea)
        {
            // Einstellen der Farben im Konsolenfenster
            Console.BackgroundColor = gameBackgroundColor;
            Console.ForegroundColor = gameBorderColor;

            // Hier wird der gesamte Inhalt des Array gameArea
            // tatsächlich in das Fenster geschrieben
            for (int row = 0; row < windowHeight - bottomBorder; row++)
            {
                for (int column = 0; column < windowWidth; column++)
                {
                    Console.SetCursorPosition(column, row);
                    Console.Write(gameArea[row, column]);
                }
            }
        }

    }
}
